<?php 
require_once 'config.php';
session_start();

// If user is already logged in, redirect to dashboard
if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_type'] === 'admin') {
        header('Location: admin-dashboard.php');
    } else {
        header('Location: customer-dashboard.php');
    }
    exit();
}

$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $error = 'Email and password are required.';
    } else {
        // Get user from database
        $stmt = $conn->prepare('SELECT id, name, password, user_type FROM users WHERE email = ?');
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            $error = 'Invalid email or password.';
        } else {
            $user = $result->fetch_assoc();
            
            // Verify password
            if (!password_verify($password, $user['password'])) {
                $error = 'Invalid email or password.';
            } else {
                // Set session variables
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_type'] = $user['user_type'];
                $_SESSION['user_email'] = $email;

                // Redirect to home page
                header('Location: index.php');
                exit();
            }
        }
        $stmt->close();
    }
}
?><!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Login - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
     <style>
        .vs-header .sticky-wrapper { position: sticky; top: 0; z-index: 1030; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1); }
        .auth-buttons { display: flex; gap: clamp(8px, 1.5vw, 16px); align-items: center; flex-wrap: wrap; }
        .auth-btn { padding: clamp(8px, 1.2vw, 14px) clamp(12px, 2vw, 18px); border: 2px solid transparent; border-radius: 8px; font-size: clamp(12px, 1.5vw, 16px); font-weight: 600; cursor: pointer; transition: all 0.3s ease; display: flex; align-items: center; gap: 6px; white-space: nowrap; background: transparent; text-decoration: none; }
        .login-btn { color: #109c3d; border-color: #109c3d; }
        .login-btn:hover { background-color: #109c3d; color: white; }
        .register-btn { color: white; background-color: #109c3d; border-color: #109c3d; }
        .register-btn:hover { background-color: #088830; border-color: #088830; }
        @media (max-width: 991px) { .auth-buttons { display: none; } }
        .login-page-wrapper { min-height: calc(100vh - 400px); display: flex; align-items: center; justify-content: center; padding: 40px 20px; background: #f8f9fa; }
        .login-form-container { width: 100%; max-width: 450px; background: white; padding: 40px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); }
        .login-form-header { text-align: center; margin-bottom: 30px; }
        .login-form-header h2 { font-size: 28px; color: #063A41; margin-bottom: 10px; }
        .login-form-header p { color: #5E5C78; font-size: 14px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; color: #063A41; font-weight: 500; }
        .form-group input { width: 100%; padding: 12px 14px; border: 1px solid #CDD5D6; border-radius: 8px; font-size: 14px; transition: border-color 0.3s; }
        .form-group input:focus { outline: none; border-color: #109c3d; box-shadow: 0 0 0 3px rgba(16, 156, 61, 0.1); }
        .form-submit-btn { width: 100%; padding: 14px; background: linear-gradient(85deg, #17a7bf 0%, #67b846 72%); color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; transition: 0.3s; margin-top: 10px; }
        .form-submit-btn:hover { opacity: 0.9; }
        .login-links { margin-top: 20px; text-align: center; font-size: 14px; }
        .login-links p { color: #5E5C78; }
        .login-links a { color: #109c3d; text-decoration: none; font-weight: 600; }
        .login-links a:hover { text-decoration: underline; }
        @media (max-width: 480px) { .auth-btn span { display: none !important; } .login-form-container { padding: 25px 15px; } }
        .footer-wrapper { color: #fff; }
        .footer-text { font-size: 14px; line-height: 1.8; opacity: 0.9; }
        .footer-widget .widget_title { font-size: 18px; margin-bottom: 18px; font-weight: 600; }
        .footer-links { display: grid; grid-template-columns: repeat(2, 1fr); gap: 8px 18px; }
        .footer-links li { list-style: none; }
        .footer-links li a { font-size: 14px; color: #eaeaea; text-decoration: none; }
        .footer-links li a:hover { color: #4fc3f7; }
        .contact-box { display: flex; gap: 12px; align-items: center; margin: 20px 0; }
        .contact-title a { color: #fff; font-weight: 600; }
        .social-icon a { width: 36px; height: 36px; border-radius: 50%; background: rgba(255,255,255,0.15); display: inline-flex; align-items: center; justify-content: center; margin-right: 6px; transition: 0.3s; }
        .social-icon a:hover { background: #4fc3f7; }
        @media (max-width: 991px) { .footer-widget { text-align: center; } .footer-links { grid-template-columns: 1fr; } .contact-box { justify-content: center; } }
        @media (max-width: 576px) { .footer-text { font-size: 13px; } .copyright-wrap { text-align: center; } .copyright-wrap img { margin-top: 12px; } }
    </style>
</head>

<body>
    
    <?php include 'header.php'; ?>
    <div class="login-page-wrapper">
        <div class="login-form-container">
            <div class="login-form-header">
                <h2>Welcome Back 🧹</h2>
                <p>Login to manage your cleaning services</p>
            </div>

            <?php if ($error): ?>
                <div style="background-color: #fee; color: #c33; padding: 12px; border-radius: 8px; margin-bottom: 20px; border-left: 4px solid #c33;">
                    <strong>Error:</strong> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" placeholder="Enter your email" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Enter your password" required>
                </div>

                <button type="submit" class="form-submit-btn">Login</button>

                <div class="login-links">
                    <p><a href="forgot_password.php">Forgot Password?</a></p>
                    <p>Don't have an account? <a href="register.php">Register here</a></p>
                </div>
            </form>
        </div>
    </div>
    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>